#import "lips_template.typ": *

// Define group and project information
#let project_definition = (
  project_title: "Ett fantastiskt LIPS-projekt",
  members: (
    (name: "Anna Andersson", role: "kundansvarig (KUN)", liuid: "annan111"),
    (name: "Beata Bson", role: "dokumentansvarig (DOK)", liuid: "beabs222"),
    (name: "Cecilia Cson", role: "designansvarig (DES)", liuid: "ceccs333"),
    (name: "Doris Dson", role: "testansvarig (TST)", liuid: "dords444"),
    (name: "Erik Eson", role: "kvalitetssamordnare (QS)", liuid: "eries555"),
    (name: "Fredrik Fson", role: "implementationsansvarig (IMP)", liuid: "frefs666"),
    (name: "Greta Gson", role: "projektledare (PL)", liuid: "gregs777"),
  ),
  group_email: "an_email@mail.com",
  group_website: "https://www.example.com",
  customer: "Institutionen för systemteknik (ISY)",
  customer_contact: (
    name: "Mattias Krysander",
    email: "mattias.krysander@liu.se",
  ),
  supervisor: (
    name: "Erik Frisk",
    email: "erik.frisk@liu.se",
  ),
  course_responsible: (
    name: "Urban Forsberg",
    email: "urban.forsberg@liu.se",
  ),
  logo: "Figures/logo.svg",
)

// Activate the template
#show: lips.with(
  title: "Generell Mall",
  editor: "Anna Andersson",
  version: "0.2",
  status: (
    ("Granskad", "Ewa, Karl", "2024-01-15"),
    ("Godkänd", "Karl", "2024-01-20"),
  ),
  // date: "2025-06-01",
  // lang: "en", // "en" and "sv" are supported
  project_definition: project_definition,
  outline_depth: 2,
  // sans_serif_font: "Helvetica",
  // serif_font: "Times New Roman",
  // font_size: 10pt,
)

= Dokumentmall och Typst
Den här mallen är skriven i Typst, ett verktyg för att typsätta dokument och bygger på så kallad, markup-syntax. Mallen efterliknar originalet, för Word, som finns på https://lips.isy.liu.se/ men har inte, av flera skäl, som ambition att vara exakt kopia. Det är inte en officiell mall. Den senaste versionen av mallen kan alltid hittas via https://lips.isy.liu.se/ och kommentarer/felrapporter kan skickas till Erik Frisk (#link("mailto:erik.frisk@liu.se", "erik.frisk@liu.se")).

Att Typst är baserat på markup gör att det är väldigt enkelt att komma igång med att skriva dokument och använda existerande mallar.
// #align(
//   center,
//   block(
//     inset: 0.75em,
//     width: 80%,
//     stroke: 1.0pt,
//     radius: 3mm,
//     align(left)[
//       Exempelvis så är detta är en text, _detta är kursiv text_ och *detta är text i
//         fetstil*. Vid behov finns möjligheter att enkelt variera text, exempelvis #text(fill: red)[#strike[det här är överstruken röd text]]. Se https://typst.app/docs/reference/text/ för mer information om textformattering.
//     ],
//   ),
// )

Exempelvis så är detta är en text, _detta är kursiv text_ och *detta är text i fetstil*.
Vid behov finns möjligheter att enkelt variera text, exempelvis #text(fill: red)[#strike[det här är överstruken röd text]]. Se https://typst.app/docs/reference/text/ för mer information om textformattering.

Det går att skriva och samarbeta runt dokumenten i sin webbläsare direkt på https://typst.app/, utan att installera något på sin egen dator.
Starta ett projekt på https://typst.app/, kopiera dit mall-filerna, och du är redo att skriva ditt dokument.

För mer information se https://typst.app/ där https://typst.app/docs/tutorial/ är ett bra ställe att börja och där finns även fullständig dokumentation.

Applikationen kan med fördel installeras lokalt på din dator om du känner att det är något du kommer använda vidare, se https://github.com/typst/typst för installationsinstruktioner för Windows, Mac, och Linux. Om du använder #link("https://code.visualstudio.com", "Visual Studio Code") för att redigera dokument så finns en användbar plugin
#link("https://marketplace.visualstudio.com/items?itemName=myriad-dreamin.tinymist", "Tinymist") som gör det enkelt att arbeta med Typst.

== Figurer och tabeller
För att infoga figurer och tabeller används `figure` och `table` funktionerna.
Exempelvis @fig_blue_marble genereras med följande kod:
#figure(placement: auto, caption: "Det berömda 'The blue marble' fotot.", image(
  "Figures/blue_marble.jpg",
  width: 50%,
))<fig_blue_marble>

#figure(placement: auto, caption: [En liten tabell], table(
  columns: 2,
  align: (center, left),
  stroke: none,
  table.header([*Amount*], [*Ingredient*]),
  table.hline(),
  [360g], [Baking flour],
  [250g], [Butter (room temp.)],
  [150g], [Brown sugar],
  [100g], [Cane sugar],
  [100g], [70% cocoa chocolate],
  [100g], [35-40% cocoa chocolate],
  [2], [Eggs],
  [Pinch], [Salt],
  [Drizzle], [Vanilla extract],
))<tab_small_table>
```typst
#figure(placement: none,
    caption: "Det berömda 'The blue marble' fotot.",
    image("Figures/blue_marble.jpg", width: 50%)
)<fig_blue_marble>
```
och @tab_small_table med
```typst
#figure(placement: none,
        caption: [En liten tabell],
        table(columns: 2, stroke: none,
            align: (center, left),
            table.header([*Amount*], [*Ingredient*]),
            table.hline(),
            [360g], [Baking flour],
            [250g], [Butter (room temp.)],
            [150g], [Brown sugar],
            [100g], [Cane sugar],
            [100g], [70% cocoa chocolate],
            [100g], [35-40% cocoa chocolate],
            [2], [Eggs],
            [Pinch], [Salt],
            [Drizzle], [Vanilla extract],
        ),
)<tab_small_table>
```

== Ekvationer
Man kan skriva ekvationer och typsätta matematik såsom
$
  F(s) = integral_(-infinity)^infinity f(t) e^(-s t) d t
$<eq_laplace>
och referera ekvationerna @eq_laplace. Koden för att generera ekvationen och referensen ovan är
```typst
Man kan skriva ekvationer och typsätta matematik såsom
$
  F(s) = integral_(-infinity)^infinity f(t) e^(-s t) d t
$<eq_laplace>
och referera ekvationerna @eq_laplace.
```

== Citeringar, referenser, och fotnötter
Eulers identitet är
$
  e^(i pi) + 1 = 0
$<eq_euler_identity>
och med $tau$, se @HartVi_2011 (se detta som ett exempel på
hur resurser on-line kan citeras),
$
  e^(i tau) = 1
$
Så här citeras ett vetenskapligt arbete @einstein1905uber, och
så här skrivs en fotnot#footnote[Var konsistent med hur ni citerar, fotnötter används sparsamt i teknikvetenskaplig litteratur.]. Information om de citerade arbetena skrivs i filen `references.bib`.
Nedan finns ett exempel till
$
  sin(x) = product_(n=1)^infinity (1 - x^2 / (n^2 pi^2))
  = sum_(n=0)^infinity (-1)^n / (2 n + 1)! x^(2n + 1)
$
som genereras med
```typst
$
  sin(x) = product_(n=1)^infinity (1 - x^2 / (n^2 pi^2))
  = sum_(n=0)^infinity (-1)^n / (2 n + 1)! x^(2n + 1)
$
```
== Programkod
Program-kod kan infogas prydligt, exempelvis kan Python-kod se ut så här:
```python
def rank(A, tol=None):
    import numpy as np
    s = np.linalg.svd(A, compute_uv=False)
    if tol is None:
        tol = max(A.shape) * np.finfo(float).eps * max(s)
    return np.sum(s > tol)
```
och det går bra att infoga kod från många andra språk, exempelvis Matlab
```matlab
function r = rank(A, tol)
s = svd(A);
if nargin==1
    tol = max(size(A)) * eps(max(s));
end
r = sum(s > tol);
```
= Dokumentmallen

För att använda mallen behöver man fylla i projektinformation samt dokumentinformation. Projektinformationen är exempelvis listan av deltagare, projekttitel, kontaktinformation etc. och dokumentinformationen är exempelvis dokumenttitel, språk, fontstorlek etc. Språk som stöds är svenska och engelska.

== Att använda mallen
Projektinformation definieras i en variabel, exempelvis `project_definition`, enligt nedan
```typst
#let project_definition = (
  project_title: "Projekttitel",
  members: (
    (name: "Anna Andersson", role: "kundansvarig (KUN)",
     liuid: "annan111"),
    (name: "Beata Bson", role: "dokumentansvarig (DOK)",
     liuid: "beabs222"),
    (name: "Cecilia Cson", role: "designansvarig (DES)",
     liuid: "ceccs333"),
    (name: "Doris Dson", role: "testansvarig (TST)",
     liuid: "dords444"),
    (name: "Erik Eson", role: "kvalitetssamordnare (QS)",
     liuid: "eries555"),
    (name: "Fredrik Fson", role: "implementationsansvarig (IMP)",
     liuid: "frefs666"),
    (name: "Greta Gson", role: "projektledare (PL)",
     liuid: "gregs777"),
  ),
  group_email: "an_email@mail.com",
  group_website: "https://www.example.com",
  customer: "Institutionen för systemteknik (ISY)",
  customer_contact: (name: "Namn",
                     email: "first.last@liu.se"),
  supervisor: (name: "Namn",
               email: "first.last@liu.se"),
  course_responsible: (name: "Namn",
                       email: "first.last@liu.se"),
  logo: "logo.svg"
)
```
och sedan aktiveras mallen med dokumentinformation enligt nedan:
```typst
#show: lips.with(
    title: "Teknisk rapport",
    editor: "Anna Andersson",
    status: (("Granskad", "Ewa, Karl", "2024-01-15"),
             ("Godkänd", "Karl", "2024-01-20")),
    date: "2025-06-01",
    project_definition: project_definition,
    outline_depth: 3,
)
```
och därefter är mallen aktiverad och det är bara att börja skriva. Se filen `lips_template.typ` för att utforska alla parametrar till mallen.

=== Fonter
Mallen är designad för att använda Libertinus Serif som font för brödtext och Libertinus Sans för rubriker. Båda fonterna finns tillgängliga direkt på https://typst.app. Vill du installera Typst lokalt, se https://github.com/typst/typst, behöver du installera fonten Libertinus Sans. För att göra det, gå till https://github.com/alerque/libertinus/releases och ladda ned senaste versionen, exempelvis `Libertinus-7.051.zip`, packa upp zip-filen, och följ instruktionerna nedan för Mac, Windows, eller Linux.

*Windows*\
Öppna filhanteraren och navigera till foldern som innehåller TTF-filerna, markera dem, högerklicka, och välj installera.

#v(1em)

*MacOS*\
Öppna Finder, navigera till foldern som innehåller TTF-filerna, markera alla TTF-filer, högerklicka och välj "Öppna med" $->$ "Fontbook". I Fontbook, klicka på installera.
#v(1em)

*Linux/Ubuntu*\
Skapa biblioteket `~/.local/share/fonts` i ditt hembibliotek och kopiera alla TTF-filer dit. Kör sedan kommandot
```bash
% fc-cache -f -v
```

== Ekvationer utan nummer
Ibland vill man skriva ekvationer med och ibland utan nummer. Med nummer,
$
  x^2 + y^2 = z^2
$
och utan nummer,
#nonumeq[$
  x^2 + y^2 = z^2.
$]
```typst
Med nummer,
$
  x^2 + y^2 = z^2
$
och utan nummer,
#nonumeq[$
  x^2 + y^2 = z^2.
$]
```

== Att skriva krav
Ett viktigt dokument i Lips är kravspecifikationen, där alla krav på systemet skrivs ned. Kraven kan också ändras under projektets gång, och det är viktigt att kunna hantera detta i dokumentationen. Se nedan för ett litet exempel som inkluderar ett tillbakadraget/ändrat krav
#requirements_table((
  Req([Orginal],[Ett krav på användargränssnittet, låt oss skriva lite mer text och se att raden bryts på ett bra sätt],
    2,
    req_label: "req_ui",
  ),
  RedactedReq([Orginal],[Ett krav på beräkningskomplexitet], 1),
  Req(
    [Ändring av @req_cl, 2025-09-01],[Ett uppdaterat krav på beräkningskomplexitet. Måste komma direkt efter det strukna kravet för att numreringen skall bli korrekt.],
    1,
    req_label: "req_cl",
  ),
  Req([Orginal],[Ett krav på styralgoritmen], 1, req_label: "req_control"),
))
där vi kan referera enskilda krav som @req_ui, @req_cl och @req_control.
Tabellen och referenserna genererades med följande kod:

```typst
#requirements_table((
  Req([Orginal],[Ett krav på användargränssnittet, låt oss skriva lite mer text och se att raden bryts på ett bra sätt],
    2,
    req_label: "req_ui",
  ),
  RedactedReq([Orginal],[Ett krav på beräkningskomplexitet], 1),
  Req(
    [Ändring av @req_cl, 2025-09-01],[Ett uppdaterat krav på beräkningskomplexitet. Måste komma direkt efter det strukna kravet för att numreringen skall bli korrekt.],
    1,
    req_label: "req_cl",
  ),
  Req([Orginal],[Ett krav på styralgoritmen], 1, req_label: "req_control"),
))
där vi kan referera enskilda krav som @req_ui, @req_cl och
@req_control.
```



== Använda sig av appendix
Appendix skrivs som övriga delar, men med en särskild rad som ändrar typen av numrering.
```typst
#show: appendix
```

#bibliography("references.bib")

#show: appendix
#pagebreak()

= Första appendix
#lorem(15)

== Rubrik i appendix A
#lorem(15)
=== Första underrubrik i appendix A
#lorem(15)

== Andra underrubrik i appendix A
#lorem(15)
=== Tredje delstycket i appendix A
#lorem(15)
