#import "lips_template.typ": * // Import template functions

// Define group and project information

#let project_definition = (
  project_title: "Ett fantastiskt LIPS-projekt",
  members: (
    (name: "Anna Andersson", role: "kundansvarig (KUN)", liuid: "annan111"),
    (name: "Beata Bson", role: "dokumentansvarig (DOK)", liuid: "beabs222"),
    (name: "Cecilia Cson", role: "designansvarig (DES)", liuid: "ceccs333"),
    (name: "Doris Dson", role: "testansvarig (TST)", liuid: "dords444"),
    (name: "Erik Eson", role: "kvalitetssamordnare (QS)", liuid: "eries555"),
    (name: "Fredrik Fson", role: "implementationsansvarig (IMP)", liuid: "frefs666"),
    (name: "Greta Gson", role: "projektledare (PL)", liuid: "gregs777"),
  ),
  group_email: "an_email@mail.com",
  group_website: "https://www.example.com",
  customer: "Institutionen för systemteknik (ISY)",
  customer_contact: (
    name: "Mattias Krysander",
    email: "mattias.krysander@liu.se",
  ),
  supervisor: (
    name: "Erik Frisk",
    email: "erik.frisk@liu.se",
  ),
  course_responsible: (
    name: "Urban Forsberg",
    email: "urban.forsberg@liu.se",
  ),
  logo: "Figures/logo.svg",
)

// Define the document metadata
#show: lips.with(
  title: "Kravspecifikation",
  editor: "Anna Andersson",
  status: (
    ("Granskad", "Ewa, Karl", "2024-01-15"),
    ("Godkänd", "Karl", "2024-01-20"),
  ),
  //   date: "2025-06-01",
  // lang: "en", // "en" and "sv" are supported
  project_definition: project_definition,
  outline_depth: 2,
)

= Inledning<sec_inledning>
I @fig_sys ser vi systemet i dess omgivning.
#figure(placement: auto, caption: "Systemet i dess omgivning", image("Figures/sys.svg", width: 80%))<fig_sys>

#requirements_table((
  Req([Orginal], [Alla dokument skall uppfylla instruktioner beskrivna i @spraknamnd_2000], 1),
))

== Parter
Text

== Syfte och mål
Text

== Användning
Text

== Bakgrundsinformation
Text

== Definitioner
Text

= Översikt av systemet
Text
#figure(placement: none, caption: "En översikt av systemet", image("Figures/outline.svg", width: 80%))

== Grov beskrivning av produkten
Text

== Produktkomponenter
Text

== Beroenden till andra system
Text

== Ingående delsystem
Text

== Avgränsningar
Text

== Designfilosofi
Text

= Delsystem 1
Text
#figure(placement: none, caption: "Delsystem 1", image("Figures/delsys1.svg", width: 80%))

== Inledande beskrivning
Text

#requirements_table((
  Req([Orginal],[Alla dokument skall uppfylla instruktioner beskrivna i @spraknamnd_2000.], 1),
  Req([Orginal],[Felmeddelanden skall vara på svenska], 1),
))

== Gränssnitt

#requirements_table((
  Req([Orginal],[Kravtext], 2, req_label: "req_another_one"),
  RedactedReq([Orginal],[Kravtext], 2),
  Req([Ändring av @req_change, 2025-09-01],[Ny kravtext], 1, req_label: "req_change"),
  Req([Orginal],[Kravtext], 2),
))
Som synes i @req_another_one ...

== Designkrav
Text
#requirements_table((
  Req([Orginal],[Kravtext], 2),
  Req([Orginal],[Kravtext], 3),
))

== Funktionella krav
Text
#requirements_table((
  Req([Orginal],[Kravtext], 2),
  Req([Orginal],[Kravtext], 3),
))

= Delsystem 2
Text

#figure(placement: none, caption: "Delsystem 2", image("Figures/delsys2.svg", width: 80%))


== Externa gränssnitt
Text
#requirements_table((
  Req([Orginal],[Kravtext], [Bas]),
))

== Designkrav
Text
#requirements_table((
  Req([Orginal],[Kravtext för designkrav], [Bas]),
))


== Funktionella krav
Text
#requirements_table((
  Req([Orginal],[Kravtext], [Bas]),
  Req([Orginal],[Mer krav], [Extra]),
))

== Användargränssnitt
Text
#requirements_table((
  Req([Orginal],[Mera krav], [Bas]),
))

= Prestandakrav
Text
#requirements_table((
  Req([Orginal],[Kravtext], [Bas]),
))

= Krav på vidareutveckling
Text
#requirements_table((
  Req([Orginal],[Kravtext], [Bas]),
))

= Tillförlitlighet
Text
#requirements_table((
  Req([Orginal],[Kravtext], [Bas]),
))

= Ekonomi
Text
#requirements_table((
  Req([Orginal],[Kravtext], [Bas]),
))

= Krav på säkerhet
Text
#requirements_table((
  Req([Orginal],[Kravtext], [Bas]),
))

= Leveranskrav och delleveranser
Text
#requirements_table((
  Req([Orginal],[Kravtext], [Bas]),
))

= Dokumentation
@tab_doks listar de dokument som skall produceras

#figure(placement: none, caption: "Dokument som skall produceras", table(
  columns: 5,
  align: (left, left, left, left, left, left),
  stroke: none,
  table.header([Dokument], [Språk], [Syfte], [Målgrupp], [Format]),
  table.hline(),
  [Projektplan], [], [], [], [],
  [Kravspecifikation], [], [], [], [],
  [Designspecifikation], [], [], [], [],
  [Mötesprotokoll], [], [], [], [],
  [Teknisk dokumentation], [], [], [], [],
  [Efterstudie], [], [], [], [],
))<tab_doks>

#requirements_table((
  Req([Orginal],[Kravtext], [Bas]),
))

= Utbildning
Text
#requirements_table((
  Req([Orginal],[Kravtext], [Bas]),
))

= Kvalitetskrav
Text
#requirements_table((
  Req([Orginal],[Kravtext], [Bas]),
))

= Underhållsbarhet
Text
#requirements_table((
  Req([Orginal],[Kravtext], [Bas]),
))


// \clearpage
// \bibliography{references}
#bibliography("references.bib")

// \cleardoublepage
// \appendix

= Appendixtitel

== Den första rubriken
// Text

// \subsubsection{Första underrubriken}
// Text

// \subsubsection{Andra underrubriken}
// Text

// \subsubsection{Tredje underrubriken}
// Text

