// LTeX: enabled=false
#import "@preview/codly:1.3.0": *
#import "@preview/ez-today:1.1.0"

#let swedish-months = (
  "januari",
  "februari",
  "mars",
  "april",
  "maj",
  "juni",
  "juli",
  "augusti",
  "september",
  "oktober",
  "november",
  "december",
)

#let req_counter = counter("req")

/*
#let requirements_table(requirements) = {
  context {
    let header = if text.lang == "sv" { ([Nr], [Krav], [Prioritet]) } else { ([No], [Requirement], [Priority]) }
    table(
      columns: (0.75fr, 5fr, 1.0fr),
      align: (center, left, center),
      stroke: none,
      table.hline(stroke: 0.75pt, position: bottom),
      table.header(..header),
      ..for req in requirements {
        req
      },
    )
  }
}
*/

#let requirements_table(requirements) = {
  context {
    let header = if text.lang == "sv" { ([Nr], [Version], [Krav], [Prioritet]) } else { ([No], [Version], [Requirement], [Priority]) }
    table(
      columns: (0.75fr, 1fr, 4fr, 1.0fr),
      align: (center, left, left, center),
      stroke: none,
      table.hline(stroke: 0.75pt, position: bottom),
      table.header(..header),
      ..for req in requirements {
        req
      },
    )
  }
}

#let RedactedReq(ver_text, req_text, priority) = {
  let no = () => req_counter.display()
  let number = () => req_counter.get().at(0)
  let req() = figure(
    kind: "req",
    numbering: none,
  )[]

  return (
    context text(fill: red)[#strike[#no()#req()]],
    text(fill: red)[#strike[#ver_text]],
    text(fill: red)[#strike[#req_text]],
    text(fill: red)[#strike[#priority]],
  )
}

#let Req(ver_text, req_text, priority, req_label: none) = {
  let no = () => req_counter.display() + req_counter.step()
  let number = () => req_counter.get().at(0)

  let req() = figure(
    kind: "req",
    supplement: context if text.lang == "sv" { "Krav" } else { "Requirement" },
    numbering: "1.",
  )[]
  if req_label == none {
    return (
      context [#no()#req()],
      ver_text,
      req_text,
      [#priority],
    )
  } else {
    return (
      context [#no()#req()#label(req_label)],
      ver_text,
      req_text,
      [#priority],
    )
  }
}

/*
#let Req(req_text, priority, req_label: none) = {
  let no = () => req_counter.display() + req_counter.step()
  let number = () => req_counter.get().at(0)

  let req() = figure(
    kind: "req",
    supplement: context if text.lang == "sv" { "Krav" } else { "Requirement" },
    numbering: "1.",
  )[]
  if req_label == none {
    return (
      context [#no()#req()],
      req_text,
      [#priority],
    )
  } else {
    return (
      context [#no()#req()#label(req_label)],
      req_text,
      [#priority],
    )
  }
}
*/

#let nonumeq = it => {
  set math.equation(numbering: none)
  it
}

#let lips(
  title: "A Title",
  editor: "An Editor",
  status: (),
  version: "0.1",
  lang: "sv",
  date: none,
  project_definition: none,
  serif_font: ("Libertinus Serif", "New Computer Modern"),
  sans_serif_font: ("Libertinus Sans", "Libertinus Serif"),
  outline_depth: 2,
  font_size: 12pt,
  body,
) = {
  show: codly-init

  let language_str = (
    en: (
      proj_id: "Project identity",
      name_str: "Name",
      responsible_str: "Responsible",
      customer_str: "Customer",
      contact: "Contact person at customer",
      course_responsible: "Course responsible",
      email_str: "E-mail to the group",
      supervisor: "Supervisor",
      no_email: "No email",
      homepage_str: "Homepage",
      no_www: "No homepage",
    ),
    sv: (
      proj_id: "Projektidentitet",
      name_str: "Namn",
      responsible_str: "Ansvar",
      customer_str: "Kund",
      contact: "Kontaktperson hos kund",
      course_responsible: "Kursansvarig",
      email_str: "E-postlista till gruppen",
      supervisor: "Handledare",
      no_email: "Ingen e-postlista",
      homepage_str: "Hemsida",
      no_www: "Ingen hemsida",
    ),
  )

  req_counter.update(1)

  let todays_date = if date != none { date } else if lang == "en" {
    ez-today.today(lang: "en", format: "M d, Y")
  } else { ez-today.today(lang: "sv", format: "Y-m-D") }

  set page(paper: "a4", margin: (left: 30mm, right: 30mm, top: 35mm, bottom: 25mm))
  set text(font: serif_font, size: font_size, lang: lang)
  set par(justify: true, leading: 0.55em, first-line-indent: if lang == "sv" { (amount: 0pt, all: false) } else {
    (amount: 1.2em, all: false)
  })

  set heading(numbering: "1.1")
  show bibliography: set heading(numbering: "1.1")
  set bibliography(
    title: if lang == "sv" { "Referenser" } else { "References" },
    style: "elsevier-vancouver",
  )

  // Configure equation numbering and spacing.
  set math.equation(numbering: "(1)")
  show math.equation: it => {
    set block(spacing: 0.65em)
    set text(weight: "regular")
    it
  }

  show figure.where(kind: table): set figure.caption(position: top)
  show figure.where(kind: "req"): it => it.body // remove block

  // Link styling
  show link: this => {
    let show-type = "filled"
    let label-color = green
    let default-color = rgb(51, 102, 204)

    if show-type == "filled" {
      if type(this.dest) == label {
        this
      } else {
        text(this, fill: default-color, weight: "regular")
      }
    } else {
      this
    }
  }

  // Styling of code blocks
  codly(
    zebra-fill: none,
    fill: rgb("#F7F7F7"),
    radius: 6pt,
    stroke: 1pt + rgb("#E0E0E0"),
    display-icon: false,
    display-name: false,
    number-format: number => [#text(size: font_size - 3pt, fill: rgb("#646669"))[#number]],
  )

  show raw: set text(size: font_size - 2pt)
  show heading.where(level: 1): it => block(width: 100%, below: 1.5em, text(
    font_size + 4pt,
    font: sans_serif_font,
    weight: "regular",
    [#counter(heading).display() #h(
        4mm,
      )#smallcaps[#it.body]],
  ))
  show heading.where(level: 2): it => block(width: 100%, below: 1em, text(
    font: sans_serif_font,
    size: font_size + 2pt,
    weight: "regular",
    style: "normal",
    [#counter(
        heading,
      ).display() #h(3mm)#it.body],
  ))

  show heading.where(level: 3): it => block(width: 100%, below: 1em, text(
    font: sans_serif_font,
    size: font_size,
    weight: "regular",
    style: "italic",
    [#counter(
        heading,
      ).display() #it.body],
  ))

  show heading.where(level: 4): it => block(width: 100%, below: 1em, text(
    font: sans_serif_font,
    size: font_size,
    weight: "regular",
    style: "italic",
    [#counter(
        heading,
      ).display() #it.body],
  ))

  // Configure appearance of equation references
  show ref: it => {
    if it.element != none and it.element.func() == math.equation {
      // Override equation references.
      link(it.element.location(), numbering(it.element.numbering, ..counter(math.equation).at(it.element.location())))
    } else {
      it
    }
  }

  set page(header: {
    set text(size: 12pt)
    // #let on_first_page = (context counter(page).get().at(0)) == 1
    place(top + left, dy: 12mm, dx: 0mm, box(width: 100%, height: auto, grid(
      columns: (30%, 1fr, 15%),
      align: (left, center, right),
      stroke: none,
      if ("logo" in project_definition) [#image(project_definition.logo, height: 12mm)] else [],
      [#v(1em)#project_definition.project_title],
      [#v(1em)#todays_date],
    )))
  })
  // Front page
  {
    set text(size: 12pt) // Always use 12pt for the front page

    set page(numbering: none)
    v(15em)
    align(center)[
      #set text(font: sans_serif_font)
      #text(size: 22pt)[#upper(title)]\
      #text(size: 14pt)[#editor]\
      #text(size: 10pt, style: "italic")[v.#version]
    ]
    v(1fr)
    if status != none and status.len() > 0 {
      set par(spacing: 0.7em)
      align(center)[
        *Status*
        #table(
          columns: (1fr, 1fr, 1fr),
          align: left,
          ..for (a, b, c) in status {
            (a, b, c)
          }
        )
      ]
    }

    set page(numbering: "i")
    pagebreak()

    align(center + horizon)[
      #text(size: 16pt, font: sans_serif_font, [*#upper(language_str.at(lang).proj_id)*])
      #table(
        columns: (auto, auto, auto),
        align: left,
        stroke: none,
        table.hline(position: bottom),
        table.header(language_str.at(lang).name_str, language_str.at(lang).responsible_str, "LiU-ID"),
        ..for member in project_definition.members {
          (member.name, member.role, member.liuid)
        },
      )
      #v(10mm)
      #align(center)[
        #if "group_email" in project_definition [
          *#language_str.at(lang).email_str*: #link("mailto:" + project_definition.group_email)\
        ] else [
          // *#language_str.at(lang).email_str*: #language_str.at(lang).no_email\
        ]
        #if "group_website" in project_definition [
          *#language_str.at(lang).homepage_str*: #link(project_definition.group_website)\
        ] else [
          // *#language_str.at(lang).homepage_str*: #language_str.at(lang).no_www\
        ]
        #v(1em)
        *#language_str.at(lang).customer_str*: #project_definition.customer\
        *#language_str.at(lang).contact*: #project_definition.customer_contact.name, #link("mailto:" + project_definition.customer_contact.email)\
        #v(1em)
        *#language_str.at(lang).course_responsible*: #project_definition.course_responsible.name, #link("mailto:" + project_definition.course_responsible.email)\
        *#language_str.at(lang).supervisor*: #project_definition.supervisor.name, #link("mailto:" + project_definition.supervisor.email)\
      ]
    ]
  }

  pagebreak()

  {
    show heading: it => block(width: 100%, below: 1em)[
      #text(
        font: sans_serif_font,
        size: 18pt,
        weight: "regular",
        style: "normal",
        it.body,
      )]
    if lang == "sv" {
      outline(title: "Innehållsförteckning", depth: outline_depth)
    } else {
      outline(title: "Table of contents", depth: outline_depth)
    }
  }

  pagebreak()
  set page(numbering: "1")
  counter(page).update(1)
  body
}

#let appendix(body) = {
  set heading(numbering: "A.1", supplement: "Appendix")
  counter(heading).update(0)
  body
}
